function [emTrq, emElPwr, emUnfeas, emPrf] = emModel(emSpd, emTrq, em)

% Limit Torque
emMaxTrq = em.maxTrq(emSpd); % Nm
emMinTrq = em.minTrq(emSpd); % Nm

% Calculate electric power consumption
switch em.lossMethod
    case 'eff'
        emSpd = emSpd.*ones(size(emTrq));
        emEff = (emSpd~=0) .* em.effMap(emSpd, emTrq) + (emSpd==0);
        emElPwr = (emTrq<0) .* emSpd.*emTrq.*emEff + (emTrq>=0) .* emSpd.*emTrq./emEff; % W
    case 'trqLossMap'
        emSpd = emSpd.*ones(size(emTrq));
        lossTrq = em.trqLossMap(emSpd, emTrq);
        emElPwr = emSpd .* (emTrq + lossTrq); % W
end

% Constraints
emSpdUnfeas = emSpd > em.maxSpd;
emTrqUnfeas = ( emTrq < 0 & emTrq < emMinTrq ) | ( emTrq >= 0 & emTrq > emMaxTrq );
emUnfeas = ( emSpdUnfeas | emTrqUnfeas );

%% Pack additional outputs
emPrf.emSpd = emSpd;
emPrf.emTrq = emTrq;
emPrf.emElPwr = emElPwr;

emPrf.emMaxTrq = emMaxTrq;
emPrf.emMinTrq = emMinTrq;

emPrf.emSpdUnfeas = emSpdUnfeas;
emPrf.emTrqUnfeas = emTrqUnfeas;

end